/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.Stack;

public class FinalClassCheck
extends Check {
    private final Stack mClasses = new Stack();

    public int[] getDefaultTokens() {
        return new int[]{14, 8};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST modifiers = aAST.findFirstToken(5);
        if (aAST.getType() == 14) {
            boolean isFinal = modifiers != null && modifiers.branchContains(39);
            boolean isAbstract = modifiers != null && modifiers.branchContains(40);
            this.mClasses.push(new ClassDesc(isFinal, isAbstract));
        } else if (!ScopeUtils.inEnumBlock(aAST)) {
            ClassDesc desc = (ClassDesc)this.mClasses.peek();
            if (modifiers != null && modifiers.branchContains(61)) {
                desc.reportPrivateCtor();
            } else {
                desc.reportNonPrivateCtor();
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() != 14) {
            return;
        }
        ClassDesc desc = (ClassDesc)this.mClasses.pop();
        if (!desc.isDeclaredAsFinal() && !desc.isDeclaredAsAbstract() && desc.hasPrivateCtor() && !desc.hasNonPrivateCtor()) {
            String className = aAST.findFirstToken(58).getText();
            this.log(aAST.getLineNo(), "final.class", (Object)className);
        }
    }

    private static final class ClassDesc {
        private final boolean mDeclaredAsFinal;
        private final boolean mDeclaredAsAbstract;
        private boolean mHasNonPrivateCtor;
        private boolean mHasPrivateCtor;

        ClassDesc(boolean aDeclaredAsFinal, boolean aDeclaredAsAbstract) {
            this.mDeclaredAsFinal = aDeclaredAsFinal;
            this.mDeclaredAsAbstract = aDeclaredAsAbstract;
        }

        void reportPrivateCtor() {
            this.mHasPrivateCtor = true;
        }

        void reportNonPrivateCtor() {
            this.mHasNonPrivateCtor = true;
        }

        boolean hasPrivateCtor() {
            return this.mHasPrivateCtor;
        }

        boolean hasNonPrivateCtor() {
            return this.mHasNonPrivateCtor;
        }

        boolean isDeclaredAsFinal() {
            return this.mDeclaredAsFinal;
        }

        boolean isDeclaredAsAbstract() {
            return this.mDeclaredAsAbstract;
        }

        public String toString() {
            return this.getClass().getName() + "[" + "final=" + this.mDeclaredAsFinal + " abstract=" + this.mDeclaredAsAbstract + " pctor=" + this.mHasPrivateCtor + " ctor=" + this.mHasNonPrivateCtor + "]";
        }
    }
}

