/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.repcache;

import java.io.File;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSEmptyRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheRecord;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentationCacheManager
implements IFSRepresentationCacheManager {
    public static final String REP_CACHE_TABLE = "rep_cache";
    private static final int REP_CACHE_DB_FORMAT = 1;
    private static final String REP_CACHE_DB_SQL = "create table rep_cache (hash text not null primary key,                         revision integer not null,                         offset integer not null,                         size integer not null,                         expanded_size integer not null); ";
    private SqlJetDb myRepCacheDB;
    private ISqlJetTable myTable;
    private FSFS myFSFS;

    public static IFSRepresentationCacheManager openRepresentationCache(FSFS fsfs) throws SVNException {
        FSRepresentationCacheManager cacheObj = new FSRepresentationCacheManager();
        try {
            cacheObj.myRepCacheDB = SqlJetDb.open((File)fsfs.getRepositoryCacheFile(), (boolean)true);
            cacheObj.myRepCacheDB.setSafetyLevel(SqlJetSafetyLevel.OFF);
            FSRepresentationCacheManager.checkFormat(cacheObj.myRepCacheDB);
            cacheObj.myTable = cacheObj.myRepCacheDB.getTable(REP_CACHE_TABLE);
        }
        catch (SqlJetException e) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
            return new FSEmptyRepresentationCacheManager();
        }
        return cacheObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createRepresentationCache(File path) throws SVNException {
        SqlJetDb db = null;
        db = SqlJetDb.open((File)path, (boolean)true);
        FSRepresentationCacheManager.checkFormat(db);
        Object var4_2 = null;
        if (db == null) return;
        try {
            db.close();
            return;
        }
        catch (SqlJetException e2) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, e2);
        }
        return;
        {
            catch (SqlJetException e) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
                Object var4_3 = null;
                if (db == null) return;
                try {
                    db.close();
                    return;
                }
                catch (SqlJetException e2) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            try {
                db.close();
                throw throwable;
            }
            catch (SqlJetException e2) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, e2);
            }
            throw throwable;
        }
    }

    private static void checkFormat(SqlJetDb db) throws SqlJetException {
        db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                int version = db.getOptions().getUserVersion();
                if (version < 1) {
                    db.getOptions().setAutovacuum(true);
                    db.runWriteTransaction(new ISqlJetTransaction(){

                        public Object run(SqlJetDb db) throws SqlJetException {
                            db.getOptions().setUserVersion(1);
                            db.createTable(FSRepresentationCacheManager.REP_CACHE_DB_SQL);
                            return null;
                        }
                    });
                } else if (version > 1) {
                    throw new SqlJetException("Schema format " + version + " not recognized");
                }
                return null;
            }
        });
    }

    public void insert(FSRepresentation representation, boolean rejectDup) throws SVNException {
        FSRepresentation oldRep;
        if (representation.getSHA1HexDigest() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_CHECKSUM_KIND, "Only SHA1 checksums can be used as keys in the rep_cache table.\n");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((oldRep = this.getRepresentationByHash(representation.getSHA1HexDigest())) != null) {
            if (rejectDup && (oldRep.getRevision() != representation.getRevision() || oldRep.getOffset() != representation.getOffset() || oldRep.getSize() != representation.getSize() || oldRep.getExpandedSize() != representation.getExpandedSize())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Representation key for checksum ''{0}'' exists in filesystem ''{1}'' with a different value ({2},{3},{4},{5}) than what we were about to store ({6},{7},{8},{9})", representation.getSHA1HexDigest(), this.myFSFS.getRepositoryRoot(), String.valueOf(oldRep.getRevision()), String.valueOf(oldRep.getOffset()), String.valueOf(oldRep.getSize()), String.valueOf(oldRep.getExpandedSize()), String.valueOf(representation.getRevision()), String.valueOf(representation.getOffset()), String.valueOf(representation.getSize()), String.valueOf(representation.getExpandedSize()));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            return;
        }
        try {
            this.myTable.insert(new Object[]{representation.getSHA1HexDigest(), new Long(representation.getRevision()), new Long(representation.getOffset()), new Long(representation.getSize()), new Long(representation.getExpandedSize())});
        }
        catch (SqlJetException e) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                try {
                    this.myRepCacheDB.close();
                }
                catch (SqlJetException e) {
                    SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
                    Object var3_2 = null;
                    this.myTable = null;
                    this.myRepCacheDB = null;
                    this.myFSFS = null;
                }
                Object var3_1 = null;
                this.myTable = null;
                this.myRepCacheDB = null;
                this.myFSFS = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.myTable = null;
                this.myRepCacheDB = null;
                this.myFSFS = null;
                throw throwable;
            }
        }
    }

    public FSRepresentation getRepresentationByHash(String hash) throws SVNException {
        FSRepresentationCacheRecord cache = this.getByHash(hash);
        if (cache != null) {
            FSRepresentation representation = new FSRepresentation();
            representation.setExpandedSize(cache.getExpandedSize());
            representation.setOffset(cache.getOffset());
            representation.setRevision(cache.getRevision());
            representation.setSize(cache.getSize());
            representation.setSHA1HexDigest(cache.getHash());
            return representation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FSRepresentationCacheRecord getByHash(String hash) throws SVNException {
        lookup = null;
        try {
            lookup = this.myTable.lookup(this.myTable.getPrimaryKeyIndexName(), new Object[]{hash});
            if (lookup.eof()) ** GOTO lbl38
            var3_3 = new FSRepresentationCacheRecord(lookup);
            var5_5 = null;
            if (lookup == null) return var3_3;
            ** GOTO lbl-1000
        }
        catch (SqlJetException e) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            var5_7 = null;
            if (lookup == null) return null;
            try {
                lookup.close();
                return null;
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
                return null;
            }
        }
        {
            catch (Throwable var4_13) {
                var5_8 = null;
                if (lookup == null) throw var4_13;
                ** try [egrp 2[TRYBLOCK] [5 : 89->98)] { 
lbl27:
                // 1 sources

                lookup.close();
                throw var4_13;
lbl29:
                // 1 sources

                catch (SqlJetException e) {
                    SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
                }
                throw var4_13;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
                return var3_3;
            }
            lookup.close();
            return var3_3;
lbl38:
            // 1 sources

            var5_6 = null;
            if (lookup == null) return null;
            try {}
            catch (SqlJetException e) {}
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            return null;
            lookup.close();
            return null;
        }
    }

    private static SVNErrorMessage convertError(SqlJetException e) {
        SVNErrorMessage err = SVNErrorMessage.create(FSRepresentationCacheManager.convertErrorCode(e), e.getMessage());
        return err;
    }

    private static SVNErrorCode convertErrorCode(SqlJetException e) {
        SqlJetErrorCode sqlCode = e.getErrorCode();
        if (sqlCode == SqlJetErrorCode.READONLY) {
            return SVNErrorCode.SQLITE_READONLY;
        }
        return SVNErrorCode.SQLITE_ERROR;
    }

    public void runWriteTransaction(final IFSSqlJetTransaction transaction) throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runWriteTransaction(new ISqlJetTransaction(){

                    public Object run(SqlJetDb db) throws SqlJetException {
                        try {
                            transaction.run();
                        }
                        catch (SVNException e) {
                            throw new SqlJetException((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            }
        }
    }

    public void runReadTransaction(final IFSSqlJetTransaction transaction) throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runReadTransaction(new ISqlJetTransaction(){

                    public Object run(SqlJetDb db) throws SqlJetException {
                        try {
                            transaction.run();
                        }
                        catch (SVNException e) {
                            throw new SqlJetException((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            }
        }
    }
}

