/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeinfoUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgLogMergeInfo
extends SvnNgOperationRunner<SVNLogEntry, SvnLogMergeInfo> {
    @Override
    public boolean isApplicable(SvnLogMergeInfo operation, SvnWcGeneration wcGeneration) throws SVNException {
        boolean targetOk = operation.getFirstTarget().isURL() || SvnOperationFactory.detectWcGeneration(operation.getFirstTarget().getFile(), true) == SvnWcGeneration.V17;
        boolean sourceOk = operation.getSource().isURL() || SvnOperationFactory.detectWcGeneration(operation.getSource().getFile(), true) == SvnWcGeneration.V17;
        return targetOk && sourceOk;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }

    @Override
    protected SVNLogEntry run(SVNWCContext context) throws SVNException {
        SVNErrorMessage errorMessage;
        SVNRevision sourceEndRevision;
        Collection<SvnRevisionRange> ranges;
        SVNURL[] root = new SVNURL[1];
        if (((SvnLogMergeInfo)this.getOperation()).getDepth() != SVNDepth.EMPTY && ((SvnLogMergeInfo)this.getOperation()).getDepth() != SVNDepth.INFINITY) {
            SVNErrorMessage errorMessage2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only depths 'infinity' and 'empty' are currently supported");
            SVNErrorManager.error(errorMessage2, SVNLogType.CLIENT);
        }
        SVNRevision sourceStartRevision = (ranges = ((SvnLogMergeInfo)this.getOperation()).getRanges()) == null || ranges.size() == 0 ? SVNRevision.UNDEFINED : ranges.iterator().next().getStart();
        SVNRevision sVNRevision = sourceEndRevision = ranges == null || ranges.size() == 0 ? SVNRevision.UNDEFINED : ranges.iterator().next().getEnd();
        if (sourceStartRevision.isLocal()) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        }
        if (sourceEndRevision.isLocal()) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        }
        if (sourceEndRevision != SVNRevision.UNDEFINED && sourceStartRevision == SVNRevision.UNDEFINED) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        }
        if (sourceEndRevision == SVNRevision.UNDEFINED && sourceStartRevision != SVNRevision.UNDEFINED) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        }
        Map<String, Map<String, SVNMergeRangeList>> targetMergeInfoCatalog = null;
        Map<String, Map<String, SVNMergeRangeList>> mergeInfoCatalog = null;
        SVNRepository sourceRepository = null;
        SVNRepository targetRepository = null;
        if (targetMergeInfoCatalog != null) {
            if (targetMergeInfoCatalog.size() == 0) {
                Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(((SvnLogMergeInfo)this.getOperation()).getFirstTarget(), ((SvnLogMergeInfo)this.getOperation()).getFirstTarget().getPegRevision(), ((SvnLogMergeInfo)this.getOperation()).getFirstTarget().getPegRevision(), null);
                targetRepository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
                root[0] = targetRepository.getRepositoryRoot(true);
            } else {
                targetMergeInfoCatalog = mergeInfoCatalog = SvnNgMergeinfoUtil.getMergeInfo(this.getWcContext(), this.getRepositoryAccess(), ((SvnLogMergeInfo)this.getOperation()).getFirstTarget(), ((SvnLogMergeInfo)this.getOperation()).getDepth() == SVNDepth.INFINITY, true, root);
            }
        } else {
            mergeInfoCatalog = SvnNgMergeinfoUtil.getMergeInfo(this.getWcContext(), this.getRepositoryAccess(), ((SvnLogMergeInfo)this.getOperation()).getFirstTarget(), ((SvnLogMergeInfo)this.getOperation()).getDepth() == SVNDepth.INFINITY, true, root);
        }
        File reposRelPath = null;
        SvnTarget target = ((SvnLogMergeInfo)this.getOperation()).getFirstTarget();
        reposRelPath = !target.isURL() ? this.getWcContext().getNodeReposRelPath(((SvnLogMergeInfo)this.getOperation()).getFirstTarget().getFile()) : SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root[0].getPath(), target.getURL().getPath()));
        if (mergeInfoCatalog == null) {
            if (((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
            }
            mergeInfoCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
            mergeInfoCatalog.put(SVNFileUtil.getFilePath(reposRelPath), new TreeMap());
        }
        Map<String, SVNMergeRangeList> history = null;
        Map<String, SVNMergeRangeList> sourceHistory = null;
        if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
            history = this.getRepositoryAccess().getHistoryAsMergeInfo(targetRepository, target, -1L, -1L);
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(((SvnLogMergeInfo)this.getOperation()).getSource(), ((SvnLogMergeInfo)this.getOperation()).getSource().getPegRevision(), ((SvnLogMergeInfo)this.getOperation()).getSource().getPegRevision(), null);
        sourceRepository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        long pathRevision = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        Structure<SvnRepositoryAccess.RevisionsPair> startRevisionPair = this.getRepositoryAccess().getRevisionNumber(sourceRepository, ((SvnLogMergeInfo)this.getOperation()).getSource(), sourceStartRevision, null);
        long startRevision = startRevisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        Structure<SvnRepositoryAccess.RevisionsPair> endRevisionPair = this.getRepositoryAccess().getRevisionNumber(sourceRepository, ((SvnLogMergeInfo)this.getOperation()).getSource(), sourceEndRevision, null);
        long endRevision = endRevisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        sourceHistory = this.getRepositoryAccess().getHistoryAsMergeInfo(null, ((SvnLogMergeInfo)this.getOperation()).getSource(), Math.max(endRevision, startRevision), Math.min(endRevision, startRevision));
        boolean oldestRevsFirst = startRevision <= endRevision;
        String reposRelPathStr = SVNFileUtil.getFilePath(reposRelPath);
        SVNMergeRangeList masterNonInheritableRangeList = new SVNMergeRangeList((SVNMergeRange[])null);
        SVNMergeRangeList masterInheritableRangeList = new SVNMergeRangeList((SVNMergeRange[])null);
        TreeMap<String, SVNMergeRangeList> inheritableSubtreeMerges = new TreeMap<String, SVNMergeRangeList>();
        for (String subtreePath : mergeInfoCatalog.keySet()) {
            Map<String, SVNMergeRangeList> subtreeSourceHistory;
            boolean isSubtree;
            Map<String, SVNMergeRangeList> subtreeMergeInfo = mergeInfoCatalog.get(subtreePath);
            Map<String, SVNMergeRangeList> subtreeHistory = null;
            boolean bl = isSubtree = !subtreePath.equals(reposRelPathStr);
            if (isSubtree) {
                String subtreeRelPath = subtreePath.substring(reposRelPathStr.length() + 1);
                subtreeSourceHistory = SVNMergeInfoUtil.appendSuffix(sourceHistory, subtreeRelPath);
                if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                    subtreeHistory = SVNMergeInfoUtil.appendSuffix(history, subtreeRelPath);
                }
            } else {
                subtreeSourceHistory = sourceHistory;
                if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                    subtreeHistory = history;
                }
            }
            if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                Map<String, SVNMergeRangeList> mergedViaHistory = SVNMergeInfoUtil.intersectMergeInfo(subtreeHistory, subtreeSourceHistory, true);
                subtreeMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(subtreeMergeInfo, mergedViaHistory);
            }
            Map<String, SVNMergeRangeList> subtreeInheritableMergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(subtreeMergeInfo, null, -1L, -1L, true);
            Map<String, SVNMergeRangeList> subtreeNonInheritableMergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(subtreeMergeInfo, null, -1L, -1L, false);
            Map<String, SVNMergeRangeList> mergedNonInheritableMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(subtreeNonInheritableMergeInfo, subtreeSourceHistory, false);
            if (!mergedNonInheritableMergeInfo.isEmpty()) {
                for (SVNMergeRangeList rl : mergedNonInheritableMergeInfo.values()) {
                    rl.setInheritable(false);
                    masterNonInheritableRangeList = masterNonInheritableRangeList.merge(rl.dup());
                }
            }
            Map<String, SVNMergeRangeList> mergedMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(subtreeInheritableMergeInfo, subtreeSourceHistory, false);
            SVNMergeRangeList subtreeMergeRangeList = new SVNMergeRangeList((SVNMergeRange[])null);
            if (!mergedMergeInfo.isEmpty()) {
                for (SVNMergeRangeList rl : mergedMergeInfo.values()) {
                    masterInheritableRangeList = masterInheritableRangeList.merge(rl.dup());
                    subtreeMergeRangeList = subtreeMergeRangeList.merge(rl.dup());
                }
            }
            inheritableSubtreeMerges.put(subtreePath, subtreeMergeRangeList);
        }
        if (!masterInheritableRangeList.isEmpty()) {
            for (String path : inheritableSubtreeMerges.keySet()) {
                SVNMergeRangeList subtreeMergedRangeList = (SVNMergeRangeList)inheritableSubtreeMerges.get(path);
                SVNMergeRangeList deletedRanges = masterInheritableRangeList.diff(subtreeMergedRangeList, true);
                if (deletedRanges.isEmpty()) continue;
                deletedRanges.setInheritable(false);
                masterNonInheritableRangeList = masterNonInheritableRangeList.merge(deletedRanges);
                masterInheritableRangeList = masterInheritableRangeList.remove(deletedRanges, false);
            }
        }
        if (((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
            masterInheritableRangeList = masterInheritableRangeList.merge(masterNonInheritableRangeList);
        } else {
            SVNMergeRangeList sourceMasterRangeList = new SVNMergeRangeList((SVNMergeRange[])null);
            for (SVNMergeRangeList rl : sourceHistory.values()) {
                sourceMasterRangeList = sourceMasterRangeList.merge(rl);
            }
            sourceMasterRangeList = sourceMasterRangeList.remove(masterNonInheritableRangeList, false);
            sourceMasterRangeList = sourceMasterRangeList.merge(masterNonInheritableRangeList);
            masterInheritableRangeList = sourceMasterRangeList.remove(masterInheritableRangeList, true);
        }
        if (masterInheritableRangeList.isEmpty()) {
            return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
        }
        ArrayList<String> mergeSourcePaths = new ArrayList<String>();
        String logTarget = null;
        SVNMergeRange youngestRange = masterInheritableRangeList.getRanges()[masterInheritableRangeList.getSize() - 1].dup();
        SVNMergeRangeList youngestRangeList = new SVNMergeRangeList(youngestRange.getEndRevision() - 1L, youngestRange.getEndRevision(), youngestRange.isInheritable());
        for (String key : sourceHistory.keySet()) {
            SVNMergeRangeList subtreeMergedList = sourceHistory.get(key);
            SVNMergeRangeList intersection = youngestRangeList.intersect(subtreeMergedList, false);
            mergeSourcePaths.add(key);
            if (intersection.isEmpty()) continue;
            logTarget = key;
        }
        if (logTarget != null && logTarget.startsWith("/")) {
            logTarget = logTarget.substring(1);
        }
        SVNURL logTargetURL = logTarget != null ? SVNWCUtils.join(root[0], SVNFileUtil.createFilePath(logTarget)) : root[0];
        this.logForMergeInfoRangeList(logTargetURL, mergeSourcePaths, ((SvnLogMergeInfo)this.getOperation()).isFindMerged(), masterInheritableRangeList, oldestRevsFirst, mergeInfoCatalog, "/" + reposRelPathStr, ((SvnLogMergeInfo)this.getOperation()).isDiscoverChangedPaths(), ((SvnLogMergeInfo)this.getOperation()).getRevisionProperties(), (ISvnObjectReceiver)this.getOperation());
        return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
    }

    private void logForMergeInfoRangeList(SVNURL sourceURL, List<String> mergeSourcePaths, boolean filteringMerged, SVNMergeRangeList rangelist, boolean oldestRevsFirst, Map<String, Map<String, SVNMergeRangeList>> targetCatalog, String absReposTargetPath, boolean discoverChangedPaths, String[] revprops, ISvnObjectReceiver<SVNLogEntry> receiver) throws SVNException {
        if (rangelist.isEmpty()) {
            return;
        }
        if (targetCatalog == null) {
            targetCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        }
        TreeMap<String, Map<String, SVNMergeRangeList>> adjustedCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        for (String relativePath : targetCatalog.keySet()) {
            Map<String, SVNMergeRangeList> mi = targetCatalog.get(relativePath);
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            adjustedCatalog.put(relativePath, mi);
        }
        List<SVNMergeRange> ranges = rangelist.getRangesAsList();
        Collections.sort(ranges);
        SVNMergeRange youngestRange = ranges.get(ranges.size() - 1);
        SVNMergeRange oldestRange = ranges.get(0);
        long youngestRev = youngestRange.getEndRevision();
        long oldestRev = oldestRange.getStartRevision();
        LogEntryReceiver filteringReceiver = new LogEntryReceiver();
        filteringReceiver.receiver = receiver;
        filteringReceiver.rangelist = rangelist;
        filteringReceiver.isFilteringMerged = filteringMerged;
        filteringReceiver.targetCatalog = adjustedCatalog;
        filteringReceiver.mergeSourcePaths = mergeSourcePaths;
        filteringReceiver.reposTargertAbsPath = absReposTargetPath;
        SvnLog log = ((SvnLogMergeInfo)this.getOperation()).getOperationFactory().createLog();
        log.setSingleTarget(SvnTarget.fromURL(sourceURL, SVNRevision.create(youngestRev)));
        log.setDiscoverChangedPaths(true);
        log.setRevisionProperties(((SvnLogMergeInfo)this.getOperation()).getRevisionProperties());
        log.setLimit(-1L);
        log.setStopOnCopy(false);
        log.setUseMergeHistory(false);
        log.addRange(oldestRevsFirst ? SvnRevisionRange.create(SVNRevision.create(oldestRev), SVNRevision.create(youngestRev)) : SvnRevisionRange.create(SVNRevision.create(youngestRev), SVNRevision.create(oldestRev)));
        log.setReceiver(filteringReceiver);
        log.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogEntryReceiver
    implements ISvnObjectReceiver<SVNLogEntry> {
        private boolean isFilteringMerged;
        private List<String> mergeSourcePaths;
        private String reposTargertAbsPath;
        private Map<String, Map<String, SVNMergeRangeList>> targetCatalog;
        private SVNMergeRangeList rangelist;
        private ISvnObjectReceiver<SVNLogEntry> receiver;

        @Override
        public void receive(SvnTarget target, SVNLogEntry logEntry) throws SVNException {
            if (logEntry.getRevision() == 0L) {
                return;
            }
            SVNMergeRangeList thisRangeList = new SVNMergeRangeList(logEntry.getRevision() - 1L, logEntry.getRevision(), true);
            SVNMergeRangeList intersection = this.rangelist.intersect(thisRangeList, false);
            if (intersection == null || intersection.isEmpty()) {
                return;
            }
            intersection = thisRangeList.intersect(this.rangelist, true);
            logEntry.setNonInheriable(intersection.isEmpty());
            if ((logEntry.isNonInheritable() || !this.isFilteringMerged) && logEntry.getChangedPaths() != null) {
                boolean allSubtreesHaveThisRev = true;
                SVNMergeRangeList thisRevRangeList = new SVNMergeRangeList(logEntry.getRevision() - 1L, logEntry.getRevision(), true);
                for (String changedPath : logEntry.getChangedPaths().keySet()) {
                    SVNMergeRangeList rlist;
                    SVNMergeRange youngestRange;
                    String mergeSourceRelTarget = null;
                    boolean interrupted = false;
                    String mSourcePath = null;
                    Iterator<String> i$ = this.mergeSourcePaths.iterator();
                    while (i$.hasNext()) {
                        String mergeSourcePath;
                        mSourcePath = mergeSourcePath = i$.next();
                        mergeSourceRelTarget = mergeSourcePath.equals(changedPath) ? "" : SVNPathUtil.getPathAsChild(mergeSourcePath, changedPath);
                        if (mergeSourceRelTarget == null) continue;
                        interrupted = true;
                        if (!"".equals(mergeSourceRelTarget) || logEntry.getChangedPaths().get(changedPath).getType() == 'M') break;
                        interrupted = false;
                        break;
                    }
                    if (!interrupted) continue;
                    String targetPathAffected = SVNPathUtil.append(this.reposTargertAbsPath, mergeSourceRelTarget);
                    if (!targetPathAffected.startsWith("/")) {
                        targetPathAffected = "/" + targetPathAffected;
                    }
                    Map<String, SVNMergeRangeList> nearestAncestorMergeInfo = null;
                    boolean ancestorIsSelf = false;
                    for (String path : this.targetCatalog.keySet()) {
                        if (!SVNPathUtil.isAncestor(path, targetPathAffected)) continue;
                        nearestAncestorMergeInfo = this.targetCatalog.get(path);
                        ancestorIsSelf = path.equals(targetPathAffected);
                        if (!ancestorIsSelf) continue;
                        break;
                    }
                    if (nearestAncestorMergeInfo != null && ancestorIsSelf && logEntry.getChangedPaths().get(changedPath).getType() != 'M' && (youngestRange = (rlist = nearestAncestorMergeInfo.get(changedPath)).getRanges()[rlist.getSize() - 1]).getEndRevision() > logEntry.getRevision()) continue;
                    boolean foundThisRevision = false;
                    if (nearestAncestorMergeInfo != null) {
                        for (String path : nearestAncestorMergeInfo.keySet()) {
                            SVNMergeRangeList inter;
                            SVNMergeRangeList rlist2 = nearestAncestorMergeInfo.get(path);
                            if (!SVNPathUtil.isAncestor(mSourcePath, path) || (inter = rlist2.intersect(thisRevRangeList, false)).isEmpty()) continue;
                            if (ancestorIsSelf) {
                                foundThisRevision = true;
                                break;
                            }
                            inter = rlist2.intersect(thisRevRangeList, true);
                            if (inter.isEmpty()) continue;
                            foundThisRevision = true;
                            break;
                        }
                    }
                    if (foundThisRevision) continue;
                    allSubtreesHaveThisRev = false;
                    break;
                }
                if (allSubtreesHaveThisRev) {
                    if (this.isFilteringMerged) {
                        logEntry.setNonInheriable(false);
                    } else {
                        return;
                    }
                }
            }
            this.receiver.receive(target, logEntry);
        }
    }
}

