/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUnlock;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteUnlock
extends SvnRemoteOperationRunner<SVNLock, SvnUnlock>
implements ISVNLockHandler {
    @Override
    public boolean isApplicable(SvnUnlock operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.hasRemoteTargets();
    }

    @Override
    protected SVNLock run() throws SVNException {
        int i = 0;
        SVNURL[] urls = new SVNURL[((SvnUnlock)this.getOperation()).getTargets().size()];
        for (SvnTarget target : ((SvnUnlock)this.getOperation()).getTargets()) {
            urls[i++] = target.getURL();
        }
        SVNHashSet paths = new SVNHashSet();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        Map pathsToTokens = new SVNHashMap();
        for (String path : paths) {
            path = SVNEncodingUtil.uriDecode(path);
            pathsToTokens.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        if (!((SvnUnlock)this.getOperation()).isBreakLock()) {
            pathsToTokens = this.fetchLockTokens(repository, pathsToTokens);
        }
        repository.unlock(pathsToTokens, ((SvnUnlock)this.getOperation()).isBreakLock(), this);
        return (SVNLock)((SvnUnlock)this.getOperation()).first();
    }

    private Map<String, String> fetchLockTokens(SVNRepository repository, Map<String, String> pathsTokensMap) throws SVNException {
        SVNHashMap tokens = new SVNHashMap();
        for (String path : pathsTokensMap.keySet()) {
            SVNLock lock = repository.getLock(path);
            if (lock == null || lock.getID() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
                continue;
            }
            tokens.put(path, lock.getID());
        }
        return tokens;
    }

    @Override
    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }

    @Override
    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCKED, null, null), -1.0);
        }
    }
}

