/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnDiffSummarize;
import org.tmatesoft.svn.core.wc2.SvnGetMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnSuggestMergeSources;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNDiffClient
extends SVNBasicClient {
    private boolean gitDiffFormat;
    private boolean showCopiesAsAdds;
    private boolean myIsAllowMixedRevisions;
    private ISVNDiffGenerator diffGenerator;
    private SVNDiffOptions diffOptions;

    public SVNDiffClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNDiffClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNDiffClient(SvnOperationFactory of) {
        super(of);
    }

    @Override
    protected void initDefaults() {
        this.setDiffGenerator(null);
        this.setMergeOptions(null);
    }

    public void setDiffGenerator(ISVNDiffGenerator diffGenerator) {
        if (diffGenerator == null) {
            diffGenerator = new DefaultSVNDiffGenerator();
        }
        this.diffGenerator = diffGenerator;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        return this.diffGenerator;
    }

    public void setMergeOptions(SVNDiffOptions diffOptions) {
        if (diffOptions == null) {
            diffOptions = new SVNDiffOptions();
        }
        this.diffOptions = diffOptions;
    }

    public SVNDiffOptions getMergeOptions() {
        return this.diffOptions;
    }

    public void doDiff(SVNURL url, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSource(SvnTarget.fromURL(url, pegRevision), rN, rM);
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(SVNURL url, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSource(SvnTarget.fromURL(url, pegRevision), rN, rM);
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File path, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSource(SvnTarget.fromFile(path, pegRevision), rN, rM);
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File[] paths, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, OutputStream result, Collection<String> changeLists) throws SVNException {
        for (File path : paths) {
            SvnDiff diff = this.getOperationsFactory().createDiff();
            diff.setDiffGenerator(this.getDiffGenerator());
            diff.setSource(SvnTarget.fromFile(path, pegRevision), rN, rM);
            diff.setDepth(depth);
            diff.setIgnoreAncestry(!useAncestry);
            diff.setOutput(result);
            diff.setApplicalbeChangelists(changeLists);
            diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
            diff.setUseGitDiffFormat(this.isGitDiffFormat());
            diff.run();
        }
    }

    public void doDiff(File path, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection<String> changeLists) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSource(SvnTarget.fromFile(path, pegRevision), rN, rM);
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setApplicalbeChangelists(changeLists);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromURL(url1, rN), SvnTarget.fromURL(url2, rM));
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromURL(url1, rN), SvnTarget.fromURL(url2, rM));
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromFile(path1, rN), SvnTarget.fromURL(url2, rM));
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection<String> changeLists) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromFile(path1, rN), SvnTarget.fromURL(url2, rM));
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setApplicalbeChangelists(changeLists);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromURL(url1, rN), SvnTarget.fromFile(path2, rM));
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection<String> changeLists) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromURL(url1, rN), SvnTarget.fromFile(path2, rM));
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setApplicalbeChangelists(changeLists);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File path1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromFile(path1, rN), SvnTarget.fromFile(path2, rM));
        diff.setDepth(SVNDepth.getInfinityOrEmptyDepth(recursive));
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiff(File path1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection<String> changeLists) throws SVNException {
        SvnDiff diff = this.getOperationsFactory().createDiff();
        diff.setDiffGenerator(this.getDiffGenerator());
        diff.setSources(SvnTarget.fromFile(path1, rN), SvnTarget.fromFile(path2, rM));
        diff.setDepth(depth);
        diff.setIgnoreAncestry(!useAncestry);
        diff.setOutput(result);
        diff.setApplicalbeChangelists(changeLists);
        diff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        diff.setUseGitDiffFormat(this.isGitDiffFormat());
        diff.run();
    }

    public void doDiffStatus(File path1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromFile(path1, SVNRevision.UNDEFINED), rN, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(File path, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromFile(path, pegRevision), rN, rM, depth, useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromFile(path1, rN), SvnTarget.fromFile(path2, rM), depth, useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromFile(path1, rN), SvnTarget.fromURL(url2, rM), SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromFile(path1, rN), SvnTarget.fromURL(url2, rM), depth, useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(url1, rN, path2, rM, SVNDepth.getUnknownOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromURL(url1, rN), SvnTarget.fromFile(path2, rM), depth, useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromURL(url1, rN), SvnTarget.fromURL(url2, rM), SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromURL(url, pegRevision), rN, rM, depth, useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(SvnTarget.fromURL(url1, rN), SvnTarget.fromURL(url2, rM), depth, useAncestry, handler);
    }

    public void doMerge(File path1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(path1, revision1, path2, revision2, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSources(SvnTarget.fromFile(path1, revision1), SvnTarget.fromFile(path2, revision2));
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public void doMerge(File path1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(path1, revision1, url2, revision2, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSources(SvnTarget.fromFile(path1, revision1), SvnTarget.fromURL(url2, revision2));
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(url1, revision1, path2, revision2, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSources(SvnTarget.fromURL(url1, revision1), SvnTarget.fromFile(path2, revision2));
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(url1, revision1, url2, revision2, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSources(SvnTarget.fromURL(url1, revision1), SvnTarget.fromURL(url2, revision2));
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public void doMerge(SVNURL url1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        ArrayList<SVNRevisionRange> ranges = new ArrayList<SVNRevisionRange>();
        ranges.add(new SVNRevisionRange(revision1, revision2));
        this.doMerge(url1, pegRevision, ranges, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision pegRevision, Collection<SVNRevisionRange> rangesToMerge, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSource(SvnTarget.fromURL(url1, pegRevision), false);
        if (rangesToMerge != null) {
            for (SVNRevisionRange range : rangesToMerge) {
                merge.addRevisionRange(SvnCodec.revisionRange(range));
            }
        }
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public void doMerge(File path1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        ArrayList<SVNRevisionRange> ranges = new ArrayList<SVNRevisionRange>();
        ranges.add(new SVNRevisionRange(revision1, revision2));
        this.doMerge(path1, pegRevision, ranges, dstPath, SVNDepth.fromRecurse(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision pegRevision, Collection<SVNRevisionRange> rangesToMerge, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.setSource(SvnTarget.fromFile(path1, pegRevision), false);
        if (rangesToMerge != null) {
            for (SVNRevisionRange range : rangesToMerge) {
                merge.addRevisionRange(SvnCodec.revisionRange(range));
            }
        }
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setDepth(depth);
        merge.setIgnoreAncestry(!useAncestry);
        merge.setForce(force);
        merge.setDryRun(dryRun);
        merge.setRecordOnly(recordOnly);
        merge.run();
    }

    public boolean isAllowMixedRevisionsWCForMerge() {
        return this.myIsAllowMixedRevisions;
    }

    public void doMergeReIntegrate(File srcPath, SVNRevision pegRevision, File dstPath, boolean dryRun) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setSource(SvnTarget.fromFile(srcPath, pegRevision), true);
        merge.setDryRun(dryRun);
        merge.run();
    }

    public void doMergeReIntegrate(SVNURL srcURL, SVNRevision pegRevision, File dstPath, boolean dryRun) throws SVNException {
        SvnMerge merge = this.getOperationsFactory().createMerge();
        merge.setMergeOptions(this.getMergeOptions());
        merge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        merge.addTarget(SvnTarget.fromFile(dstPath));
        merge.setSource(SvnTarget.fromURL(srcURL, pegRevision), true);
        merge.setDryRun(dryRun);
        merge.run();
    }

    public void doGetLogMergedMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromFile(path, pegRevision));
        mergeinfo.setSource(SvnTarget.fromURL(mergeSrcURL, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(true);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromURL(url, pegRevision));
        mergeinfo.setSource(SvnTarget.fromURL(mergeSrcURL, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(true);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogMergedMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromFile(path, pegRevision));
        mergeinfo.setSource(SvnTarget.fromFile(mergeSrcPath, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(true);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromURL(url, pegRevision));
        mergeinfo.setSource(SvnTarget.fromFile(mergeSrcPath, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(true);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogEligibleMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromFile(path, pegRevision));
        mergeinfo.setSource(SvnTarget.fromURL(mergeSrcURL, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(false);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromURL(url, pegRevision));
        mergeinfo.setSource(SvnTarget.fromURL(mergeSrcURL, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(false);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogEligibleMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromFile(path, pegRevision));
        mergeinfo.setSource(SvnTarget.fromFile(mergeSrcPath, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(false);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public void doGetLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, final ISVNLogEntryHandler handler) throws SVNException {
        SvnLogMergeInfo mergeinfo = this.getOperationsFactory().createLogMergeInfo();
        mergeinfo.addTarget(SvnTarget.fromURL(url, pegRevision));
        mergeinfo.setSource(SvnTarget.fromFile(mergeSrcPath, srcPegRevision));
        mergeinfo.setDiscoverChangedPaths(discoverChangedPaths);
        mergeinfo.setRevisionProperties(revisionProperties);
        mergeinfo.setFindMerged(false);
        mergeinfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                handler.handleLogEntry(object);
            }
        });
        mergeinfo.run();
    }

    public Map<SVNURL, SVNMergeRangeList> doGetMergedMergeInfo(File path, SVNRevision pegRevision) throws SVNException {
        SvnGetMergeInfo mi = this.getOperationsFactory().createGetMergeInfo();
        mi.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        return (Map)mi.run();
    }

    public Map<SVNURL, SVNMergeRangeList> doGetMergedMergeInfo(SVNURL url, SVNRevision pegRevision) throws SVNException {
        SvnGetMergeInfo mi = this.getOperationsFactory().createGetMergeInfo();
        mi.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        return (Map)mi.run();
    }

    public Collection<SVNURL> doSuggestMergeSources(File path, SVNRevision pegRevision) throws SVNException {
        SvnSuggestMergeSources sms = this.getOperationsFactory().createSuggestMergeSources();
        sms.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        return (Collection)sms.run();
    }

    public Collection<SVNURL> doSuggestMergeSources(SVNURL url, SVNRevision pegRevision) throws SVNException {
        SvnSuggestMergeSources sms = this.getOperationsFactory().createSuggestMergeSources();
        sms.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        return (Collection)sms.run();
    }

    public void doPatch(File absPatchPath, File localAbsPath, boolean dryRun, int stripCount) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    private void doDiffStatus(SvnTarget source, SVNRevision rN, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        SvnDiffSummarize diffSummarize = this.getOperationsFactory().createDiffSummarize();
        diffSummarize.setSource(source, rN, rM);
        diffSummarize.setDepth(depth);
        diffSummarize.setIgnoreAncestry(!useAncestry);
        diffSummarize.setReceiver(SvnCodec.diffStatusReceiver(handler));
        diffSummarize.run();
    }

    private void doDiffStatus(SvnTarget source1, SvnTarget source2, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        SvnDiffSummarize diffSummarize = this.getOperationsFactory().createDiffSummarize();
        diffSummarize.setSources(source1, source2);
        diffSummarize.setDepth(depth);
        diffSummarize.setIgnoreAncestry(!useAncestry);
        diffSummarize.setReceiver(SvnCodec.diffStatusReceiver(handler));
        diffSummarize.run();
    }

    public void setAllowMixedRevisionsWCForMerge(boolean allowMixedRevisions) {
        this.myIsAllowMixedRevisions = allowMixedRevisions;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public void setShowCopiesAsAdds(boolean showCopiesAsAdds) {
        this.showCopiesAsAdds = showCopiesAsAdds;
    }

    public boolean isGitDiffFormat() {
        return this.gitDiffFormat;
    }

    public void setGitDiffFormat(boolean gitDiffFormat) {
        this.gitDiffFormat = gitDiffFormat;
    }
}

