/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NicConfigurationContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlBootProtocolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIpReader;
import org.ovirt.engine.sdk4.types.NicConfiguration;

public class XmlNicConfigurationReader {
    public static NicConfiguration readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        NicConfigurationContainer object = new NicConfigurationContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block18: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "boot_protocol": {
                    object.bootProtocol(XmlBootProtocolReader.readOne(reader));
                    continue block18;
                }
                case "ip": {
                    object.ip(XmlIpReader.readOne(reader));
                    continue block18;
                }
                case "ipv6": {
                    object.ipv6(XmlIpReader.readOne(reader));
                    continue block18;
                }
                case "ipv6_boot_protocol": {
                    object.ipv6BootProtocol(XmlBootProtocolReader.readOne(reader));
                    continue block18;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block18;
                }
                case "on_boot": {
                    object.onBoot(reader.readBoolean());
                    continue block18;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block18;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNicConfigurationReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<NicConfiguration> iterateMany(final XmlReader reader) {
        return new Iterator<NicConfiguration>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public NicConfiguration next() {
                NicConfiguration next = XmlNicConfigurationReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<NicConfiguration> readMany(XmlReader reader) {
        ArrayList<NicConfiguration> list = new ArrayList<NicConfiguration>();
        Iterator<NicConfiguration> iterator = XmlNicConfigurationReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NicConfigurationContainer object, String[] link) {
    }
}

