/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.IscsiBondBuilder;
import org.ovirt.engine.sdk4.builders.MacPoolBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.VersionBuilder;
import org.ovirt.engine.sdk4.internal.containers.DataCenterContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.DataCenterStatus;
import org.ovirt.engine.sdk4.types.IscsiBond;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaModeType;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.StorageFormat;
import org.ovirt.engine.sdk4.types.Version;

public class DataCenterBuilder {
    private List<Cluster> clusters;
    private String comment;
    private String description;
    private String href;
    private String id;
    private List<IscsiBond> iscsiBonds;
    private Boolean local;
    private MacPool macPool;
    private String name;
    private List<Network> networks;
    private List<Permission> permissions;
    private List<Qos> qoss;
    private QuotaModeType quotaMode;
    private List<Quota> quotas;
    private DataCenterStatus status;
    private List<StorageDomain> storageDomains;
    private StorageFormat storageFormat;
    private List<Version> supportedVersions;
    private Version version;

    public DataCenterBuilder clusters(List<Cluster> newClusters) {
        if (newClusters != null) {
            if (this.clusters == null) {
                this.clusters = new ArrayList<Cluster>(newClusters);
            } else {
                this.clusters.addAll(newClusters);
            }
        }
        return this;
    }

    public DataCenterBuilder clusters(Cluster ... newClusters) {
        if (newClusters != null) {
            if (this.clusters == null) {
                this.clusters = new ArrayList<Cluster>(newClusters.length);
            }
            Collections.addAll(this.clusters, newClusters);
        }
        return this;
    }

    public DataCenterBuilder clusters(ClusterBuilder ... newClusters) {
        if (newClusters != null) {
            if (this.clusters == null) {
                this.clusters = new ArrayList<Cluster>(newClusters.length);
            }
            for (ClusterBuilder builder : newClusters) {
                this.clusters.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DataCenterBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DataCenterBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DataCenterBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DataCenterBuilder iscsiBonds(List<IscsiBond> newIscsiBonds) {
        if (newIscsiBonds != null) {
            if (this.iscsiBonds == null) {
                this.iscsiBonds = new ArrayList<IscsiBond>(newIscsiBonds);
            } else {
                this.iscsiBonds.addAll(newIscsiBonds);
            }
        }
        return this;
    }

    public DataCenterBuilder iscsiBonds(IscsiBond ... newIscsiBonds) {
        if (newIscsiBonds != null) {
            if (this.iscsiBonds == null) {
                this.iscsiBonds = new ArrayList<IscsiBond>(newIscsiBonds.length);
            }
            Collections.addAll(this.iscsiBonds, newIscsiBonds);
        }
        return this;
    }

    public DataCenterBuilder iscsiBonds(IscsiBondBuilder ... newIscsiBonds) {
        if (newIscsiBonds != null) {
            if (this.iscsiBonds == null) {
                this.iscsiBonds = new ArrayList<IscsiBond>(newIscsiBonds.length);
            }
            for (IscsiBondBuilder builder : newIscsiBonds) {
                this.iscsiBonds.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder local(boolean newLocal) {
        this.local = newLocal;
        return this;
    }

    public DataCenterBuilder local(Boolean newLocal) {
        this.local = newLocal;
        return this;
    }

    public DataCenterBuilder macPool(MacPool newMacPool) {
        this.macPool = newMacPool;
        return this;
    }

    public DataCenterBuilder macPool(MacPoolBuilder newMacPool) {
        this.macPool = newMacPool == null ? null : newMacPool.build();
        return this;
    }

    public DataCenterBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DataCenterBuilder networks(List<Network> newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks);
            } else {
                this.networks.addAll(newNetworks);
            }
        }
        return this;
    }

    public DataCenterBuilder networks(Network ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            Collections.addAll(this.networks, newNetworks);
        }
        return this;
    }

    public DataCenterBuilder networks(NetworkBuilder ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            for (NetworkBuilder builder : newNetworks) {
                this.networks.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public DataCenterBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public DataCenterBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder qoss(List<Qos> newQoss) {
        if (newQoss != null) {
            if (this.qoss == null) {
                this.qoss = new ArrayList<Qos>(newQoss);
            } else {
                this.qoss.addAll(newQoss);
            }
        }
        return this;
    }

    public DataCenterBuilder qoss(Qos ... newQoss) {
        if (newQoss != null) {
            if (this.qoss == null) {
                this.qoss = new ArrayList<Qos>(newQoss.length);
            }
            Collections.addAll(this.qoss, newQoss);
        }
        return this;
    }

    public DataCenterBuilder qoss(QosBuilder ... newQoss) {
        if (newQoss != null) {
            if (this.qoss == null) {
                this.qoss = new ArrayList<Qos>(newQoss.length);
            }
            for (QosBuilder builder : newQoss) {
                this.qoss.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder quotaMode(QuotaModeType newQuotaMode) {
        this.quotaMode = newQuotaMode;
        return this;
    }

    public DataCenterBuilder quotas(List<Quota> newQuotas) {
        if (newQuotas != null) {
            if (this.quotas == null) {
                this.quotas = new ArrayList<Quota>(newQuotas);
            } else {
                this.quotas.addAll(newQuotas);
            }
        }
        return this;
    }

    public DataCenterBuilder quotas(Quota ... newQuotas) {
        if (newQuotas != null) {
            if (this.quotas == null) {
                this.quotas = new ArrayList<Quota>(newQuotas.length);
            }
            Collections.addAll(this.quotas, newQuotas);
        }
        return this;
    }

    public DataCenterBuilder quotas(QuotaBuilder ... newQuotas) {
        if (newQuotas != null) {
            if (this.quotas == null) {
                this.quotas = new ArrayList<Quota>(newQuotas.length);
            }
            for (QuotaBuilder builder : newQuotas) {
                this.quotas.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder status(DataCenterStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public DataCenterBuilder storageDomains(List<StorageDomain> newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains);
            } else {
                this.storageDomains.addAll(newStorageDomains);
            }
        }
        return this;
    }

    public DataCenterBuilder storageDomains(StorageDomain ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            Collections.addAll(this.storageDomains, newStorageDomains);
        }
        return this;
    }

    public DataCenterBuilder storageDomains(StorageDomainBuilder ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            for (StorageDomainBuilder builder : newStorageDomains) {
                this.storageDomains.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder storageFormat(StorageFormat newStorageFormat) {
        this.storageFormat = newStorageFormat;
        return this;
    }

    public DataCenterBuilder supportedVersions(List<Version> newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions);
            } else {
                this.supportedVersions.addAll(newSupportedVersions);
            }
        }
        return this;
    }

    public DataCenterBuilder supportedVersions(Version ... newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions.length);
            }
            Collections.addAll(this.supportedVersions, newSupportedVersions);
        }
        return this;
    }

    public DataCenterBuilder supportedVersions(VersionBuilder ... newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions.length);
            }
            for (VersionBuilder builder : newSupportedVersions) {
                this.supportedVersions.add(builder.build());
            }
        }
        return this;
    }

    public DataCenterBuilder version(Version newVersion) {
        this.version = newVersion;
        return this;
    }

    public DataCenterBuilder version(VersionBuilder newVersion) {
        this.version = newVersion == null ? null : newVersion.build();
        return this;
    }

    public DataCenter build() {
        DataCenterContainer container = new DataCenterContainer();
        container.clusters(this.clusters);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.iscsiBonds(this.iscsiBonds);
        container.local(this.local);
        container.macPool(this.macPool);
        container.name(this.name);
        container.networks(this.networks);
        container.permissions(this.permissions);
        container.qoss(this.qoss);
        container.quotaMode(this.quotaMode);
        container.quotas(this.quotas);
        container.status(this.status);
        container.storageDomains(this.storageDomains);
        container.storageFormat(this.storageFormat);
        container.supportedVersions(this.supportedVersions);
        container.version(this.version);
        return container;
    }
}

