/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.IscsiBond;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class IscsiBondContainer
extends IdentifiedContainer
implements IscsiBond {
    private DataCenter dataCenter;
    private List<Network> networks;
    private List<StorageConnection> storageConnections;

    @Override
    public DataCenter dataCenter() {
        return this.dataCenter;
    }

    public void dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
    }

    @Override
    public boolean dataCenterPresent() {
        return this.dataCenter != null;
    }

    @Override
    public List<Network> networks() {
        return IscsiBondContainer.makeUnmodifiableList(this.networks);
    }

    public void networks(List<Network> newNetworks) {
        this.networks = IscsiBondContainer.makeArrayList(newNetworks);
    }

    @Override
    public boolean networksPresent() {
        return this.networks != null && !this.networks.isEmpty();
    }

    @Override
    public List<StorageConnection> storageConnections() {
        return IscsiBondContainer.makeUnmodifiableList(this.storageConnections);
    }

    public void storageConnections(List<StorageConnection> newStorageConnections) {
        this.storageConnections = IscsiBondContainer.makeArrayList(newStorageConnections);
    }

    @Override
    public boolean storageConnectionsPresent() {
        return this.storageConnections != null && !this.storageConnections.isEmpty();
    }
}

